<!DOCTYPE HTML>
<?PHP
	require 'functions.php';
	checkLogin();
	$db_link = connect();

	$rep_year = date("Y",time());
	$rep_month = date("m",time());

	//Make array for exporting data
	$_SESSION['rep_export'] = array();
	$_SESSION['rep_exp_title'] = $rep_year.'-'.$rep_month.'_loans-active';

	//Select Active Loans from LOANS
	$sql_loans = "SELECT * FROM loans LEFT JOIN loanstatus ON loans.loanstatus_id = loanstatus.loanstatus_id LEFT JOIN customer ON loans.cust_id = customer.cust_id WHERE loans.loanstatus_id = 2 ORDER BY loan_dateout, loans.cust_id";
	$query_loans = mysqli_query($db_link, $sql_loans);
	checkSQL($db_link, $query_loans);
?>
<html>
	<?PHP includeHead('Active Loans',1) ?>

	<body>
		<!-- MENU -->
		<?PHP includeMenu(3);	?>
		<div id="menu_main"> <!--
			<a href="loans_search.php">Search</a>
			<a href="loans_act.php" id="item_selected">Active Loans</a>
			<a href="loans_pend.php">Pending Loans</a> -->
            <a href="loans_search.php">Back</a>
			<!--	<a href="loans_securities.php">Loan Securities</a> -->
		</div>
        
                <!-- tables pagination -->
        <link rel="stylesheet" href="css/paginationTable.css">
        
        <link href="http://maxcdn.bootstrapcdn.com/bootstrap/3.2.0/css/bootstrap.min.css" rel="stylesheet">   
        <script src="http://ajax.googleapis.com/ajax/libs/jquery/1.7.1/jquery.min.js"></script>
        <link rel="stylesheet" href="http://cdn.datatables.net/1.10.2/css/jquery.dataTables.min.css">
        <script type="text/javascript" src="http://cdn.datatables.net/1.10.2/js/jquery.dataTables.min.js"></script>
        <script type="text/javascript" src="http://maxcdn.bootstrapcdn.com/bootstrap/3.2.0/js/bootstrap.min.js"></script>
        
    <div class="container2">
        
    <h3 class="actCusttHeading">Active Loans</h3>
    <div class="exportCdata">
    <form class="export" action="rep_export.php" method="post">
        <!-- Export Button -->	
        <input type="submit" style="background-color: #4682B4 !important; color: #ffffff;" name="export_rep" value="Export" />				
    </form>
    </div>
    <!-- TABLE: Active Customers -->
    <table id="myTable" class="table table-striped table-bordered table-responsive table-hover" >
		<thead>
			<tr> 
            <th scope="col">Loan No</th>
			<th scope="col">Customer</th>
			<th scope="col">Loan Period</th>
			<th scope="col">Principal</th>
			<th scope="col">Interest</th>
			<th scope="col">Remaining</th>
			<th scope="col">Issued on</th>
			</tr>
		</thead>
        <tbody> 
        <?php   $count = 0;
		while($row_loans = mysqli_fetch_assoc($query_loans)) { 
        $loan_balances = getLoanBalance($db_link, $row_loans['loan_id']);    
            ?>
		<tr>  
            <td data-label="Loan No">
                <a href="loan.php?lid=<?php echo $row_loans['loan_id']; ?>"><?php echo $row_loans['loan_no']; ?></a>
            </td>
            
			<td data-label="Customer">
                <?php  echo $row_loans['cust_name']; ?> 
                <a href="customer.php?cust=<?php echo $row_loans['cust_id'];?>">
                    (<?php echo $row_loans['cust_no'];?>)
                </a>
            </td>
            
			<td data-label="Loan Period"><?php echo $row_loans['loan_period']; ?></td>
            
			<td data-label="Principal">
                <?php echo number_format($loan_balances['pdue']).' '.$_SESSION['set_cur']; ?>
            </td>
			<td data-label="Interest">
                <?php echo number_format($loan_balances['idue']).' '.$_SESSION['set_cur']; ?>
            </td>
			<td data-label="Remaining">
                <?php echo number_format($loan_balances['balance']).' '.$_SESSION['set_cur']; ?>
            </td>
            
            <td data-label="Issued on"><?php echo date("d.m.Y", $row_loans['loan_dateout']); ?></td>
        
		</tr> 
        <?php                                                    
            /* Export Customer Data array */                                           
            array_push($_SESSION['rep_export'], array("Loan No." => $row_loans['loan_no'], "Customer" => $row_loans['cust_name'].' ('.$row_loans['cust_no'].')', "Status" => $row_loans['loanstatus_status'],"Loan Period" => $row_loans['loan_period'], "Principal" => $loan_balances['pdue'], "Interest" => $loan_balances['idue'], "Remaining" => $loan_balances['balance'], "Issued on" => date("d.m.Y", $row_loans['loan_dateout'])));
                                                                  
            $count++;   }	?>
        </tbody>  
    </table>
        <hr class="new1" style="border-top: 1px solid #FB788E;">		
    </div>

        <?php include 'views/partial/footer.php'; ?>
        <script src="js/atcMFmainJS.js"></script>
	</body>
<script>
$(document).ready(function(){
    $('#myTable').dataTable();
});
</script>
</html>
